/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.actions.watch.state.get;

import com.floragunn.searchguard.user.User;
import com.floragunn.signals.Signals;
import com.floragunn.signals.SignalsTenant;
import com.floragunn.signals.SignalsUnavailableException;
import com.floragunn.signals.actions.watch.state.get.GetWatchStateRequest;
import com.floragunn.signals.actions.watch.state.get.GetWatchStateResponse;
import com.floragunn.signals.watch.state.WatchState;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class TransportGetWatchStateAction
extends HandledTransportAction<GetWatchStateRequest, GetWatchStateResponse> {
    private static final Logger log = LogManager.getLogger(TransportGetWatchStateAction.class);
    private final Signals signals;
    private final ThreadPool threadPool;

    @Inject
    public TransportGetWatchStateAction(Signals signals, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super("cluster:admin:searchguard:tenant:signals:watch:state/get", transportService, actionFilters, GetWatchStateRequest::new);
        this.signals = signals;
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, GetWatchStateRequest request, ActionListener<GetWatchStateResponse> listener) {
        try {
            ThreadContext threadContext = this.threadPool.getThreadContext();
            User user = (User)threadContext.getTransient("_sg_user");
            if (user == null) {
                throw new RuntimeException("Request did not contain user");
            }
            SignalsTenant signalsTenant = this.signals.getTenant(user);
            this.threadPool.generic().submit(() -> {
                Map<String, WatchState> watchStates = signalsTenant.getWatchStateReader().get(request.getWatchIds());
                listener.onResponse((Object)new GetWatchStateResponse(RestStatus.OK, this.toBytesReferenceMap(watchStates)));
            });
        }
        catch (SignalsUnavailableException e) {
            listener.onFailure((Exception)e.toElasticsearchException());
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private Map<String, BytesReference> toBytesReferenceMap(Map<String, WatchState> map) {
        HashMap<String, BytesReference> result = new HashMap<String, BytesReference>(map.size());
        for (Map.Entry<String, WatchState> entry : map.entrySet()) {
            try {
                XContentBuilder builder = XContentFactory.jsonBuilder();
                try {
                    builder.value((Object)entry.getValue());
                    result.put(entry.getKey(), BytesReference.bytes((XContentBuilder)builder));
                }
                finally {
                    if (builder == null) continue;
                    builder.close();
                }
            }
            catch (Exception e) {
                log.error("Error while writing " + entry.getKey(), (Throwable)e);
            }
        }
        return result;
    }
}

